//------------------------------------------------------------
// Copyright Sandlot Games, 2007
// author: Michael Felice
// file: svr_savecharacter.cs
// brief:
//    This handles the saving and loading of characters through
//    script, ensuring that the dynamic fields of objects and
//    timers are appropriately saved and initialized on load.
//------------------------------------------------------------


// SAVING TO FILE

// unhappiness
// has timer (produce)
//    elapsed time (produce)
// has timer (consume)
//    elapsed time (consume)
// has timer (collect)
//    total time (collect)
//    elapsed time (collect)
function CharacterServer::SaveToFile(%component)
{
   %object = %component.getObjectId();
   %datablock = %component.getDataBlock();
   
   slgSaveBool(%object.amigo);
   slgSaveBool(%object.restoreOutfit);
   slgSaveFloat(%object.homelessUnhappy);
   slgSaveFloat(%object.drunkUnhappy);
   slgSaveFloat(%object.joblessUnhappy);
   slgSaveFloat(%component.getHunger());
   slgSaveBool(%object.restoreOutfit);
   slgSaveInt(%object.animationIndex);
   slgSaveFloat(%object.animationTime);
   
   // save the hunger icon
   %hasIcon = isObject(%object.hungerIcon);
   slgSaveBool(%hasIcon);
   if (%hasIcon == true)
   {
      slgSaveBool(%object.hungerIcon.visible);
   }
   
   // save the unhappiness icon
   %hasIcon = isObject(%object.unhappinessIcon);
   slgSaveBool(%hasIcon);
   if (%hasIcon == true)
   {
      slgSaveBool(%object.unhappinessIcon.visible);
   }

   // stacked icon timer
   %hasTimer = isObject(%object.stackedIcon);
   slgSaveBool(%hasTimer);
   if (%hasIcon == true)
   {
      %elapsedTime = %object.stackedIcon.getElapsedTime();
      %totalTime = %object.stackedIcon.getTotalTime();
      slgSaveFloat(%elapsedTime);
      slgSaveFloat(%totalTime);
   }
   
   %hasTimer = isObject(%component.produceTimer);
   slgSaveBool(%hasTimer);
   if (%hasTimer == true)
   {
      %elapsedTime = %component.produceTimer.getElapsedTime();
      slgSaveFloat(%elapsedTime);
   }
   
   %hasTimer = isObject(%component.consumeTimer);
   slgSaveBool(%hasTimer);
   if (%hasTimer == true)
   {
      %elapsedTime = %component.consumeTimer.getElapsedTime();
      slgSaveFloat(%elapsedTime);
   }
   
   %hasTimer = isObject(%component.collectTimer);
   slgSaveBool(%hasTimer);
   if (%hasTimer == true)
   {
      %totalTime = %component.collectTimer.getTotalTime();
      %elapsedTime = %component.collectTimer.getElapsedTime();
      slgSaveFloat(%totalTime);
      slgSaveFloat(%elapsedTime);
   }
   
   // save the bandit target information
   %hasBanditTarget = isObject(%object.banditTarget);
   slgSaveBool(%hasBanditTarget);
   if (%hasBanditTarget == true)
   {
      %saveID = %object.banditTarget.getSaveID();
      slgSaveInt(%saveID);
   }
   
   // save the uninitialization flag
   slgSaveBool(%component.uninitialize);
   
   // save death prop production state
   slgSaveBool(%object.noDeathProps);
}



// LOADING FROM FILE

// unhappiness
// has timer (produce)
//    elapsed time (produce)
// has timer (consume)
//    elapsed time (consume)
// has timer (collect)
//    total time (collect)
//    elapsed time (collect)
function CharacterServer::LoadFromFile(%component)
{
   %object = %component.getObjectId();
   %datablock = %component.getDataBlock();
   
   %object.amigo = slgLoadBool();
   %object.restoreOutfit = slgLoadBool();
   %object.homelessUnhappy = slgLoadFloat();
   %object.drunkUnhappy = slgLoadFloat();
   %object.joblessUnhappy = slgLoadFloat();
   %component.setHunger(slgLoadFloat());
   %object.restoreOutfit = slgLoadBool();
   %object.animationIndex = slgLoadInt();
   %object.animationTime = slgLoadFloat();
   
   // save the hunger icon
   %hasIcon = slgLoadBool();
   if (%hasIcon == true)
   {
      %icon = new SLGuiTarget() 
      {
         extent  = $IconHungerExtent;
         bitmap  = $IconHungerBitmap;
         visible = slgLoadBool();
         
         // gui target fields
         target       = %object;
         renderFront  = true;
         worldOffset  = $IconHungerWorldOff;
         screenOffset = $IconHungerScreenOff;
      };
      %object.hungerIcon = %icon;
      HungerIconGroup.addGuiControl(%icon);
   }
   
   // save the unhappiness icon
   %hasIcon = slgLoadBool();
   if (%hasIcon == true)
   {
      %icon = new SLGuiTarget() 
      {
         extent  = $IconUnhappinessExtent;
         bitmap  = $IconUnhappinessBitmap;
         visible = slgLoadBool();
         
         // gui target fields
         target       = %object;
         renderFront  = true;
         worldOffset  = $IconUnhappinessWorldOff;
         screenOffset = $IconUnhappinessScreenOff;
      };
      %object.unhappinessIcon = %icon;
      UnhappinessIconGroup.addGuiControl(%icon);
   }

   // stacked icon timer
   %hasTimer = slgLoadBool();
   if (%hasIcon == true)
   {
      %elapsedTime = slgLoadFloat();
      %totalTime = slgLoadFloat();
      %object.stackedIcon = new SLTimer()
      {
         time = %totalTime;
      };
      %object.stackedIcon.setElapsedTime(%elapsedTime);
      %object.stackedIcon.notifyOnFire(SwapStackedIcons, %object);
   }
   
   %hasTimer = slgLoadBool();
   if (%hasTimer == true)
   {
      %elapsedTime = slgLoadFloat();

      if (isObject(%component.produceTimer) == true)
      {
         %component.produceTimer.delete();
      }      
      %component.produceTimer = new SLTimer()
      {
         time = %datablock.produceTime;
      };
      %component.produceTimer.notifyOnFire(onProduce, %component);
      %component.produceTimer.setElapsedTime(%elapsedTime);
   }
   
   %hasTimer = slgLoadBool();
   if (%hasTimer == true)
   {
      %elapsedTime = slgLoadFloat();
      
      if (isObject(%component.consumeTimer) == true)
      {
         %component.consumeTimer.delete();
      }
      %component.consumeTimer = new SLTimer()
      {
         time = %datablock.consumeTime;
      };
      %component.consumeTimer.notifyOnFire(onConsume, %component);
      %component.consumeTimer.setElapsedTime(%elapsedTime);
   }
   
   %hasTimer = slgLoadBool();
   if (%hasTimer == true)
   {
      %totalTime = slgLoadFloat();
      %elapsedTime = slgLoadFloat();
      
      if (isObject(%component.collectTimer) == true)
      {
         %component.collectTimer.delete();
      }
      %component.collectTimer = new SLTimer()
      {
         time = %totalTime;
      };
      %component.collectTimer.notifyOnUpdate(onCheckCollect, %component);
      %component.collectTimer.notifyOnFire(onCollect, %component);
      %component.collectTimer.setElapsedTime(%elapsedTime);
   }
   
   // load the bandit target information
   %hasBanditTarget = slgLoadBool();
   if (%hasBanditTarget == true)
   {
      %saveID = slgLoadInt();
      %object.banditTarget = slgGetGameObject(%saveID);
   }
   
   // load the uninitialization flag
   %component.uninitialize = slgLoadBool();
   
   // load death prop production state
   %object.noDeathProps = slgLoadBool();
}
